﻿/* Skript zur Demonstration von Gruppenfunktionen
 * Als Benutzer SCOTT ausführen
 */
 
  
-- Verwendung mehrerer Gruppenfunktionen in einer Abfrage
select min(sal) min_sal, 
       max(sal) max_sal,
       round(avg(sal), 1) avg_sal,
       sum(sal) sum_sal,
       count(sal) cnt
  from emp;
  
-- Verwendung der Funktion MEDIAN, VARIANCE und STDDEV
select median(empno), variance(empno), stddev(empno)
  from emp;
  
  
-- Verwendung der Funktion AVG mit NULL
select avg(mgr)
  from emp;
  
-- Die Verwendung der Funktion COUNT mit unterschiedlich vielen null-Werten
select count(*), count(mgr), count(comm)
  from emp;
  
-- Verwendung der Funktion AVG mit einem Ersatzwert für NULL
select avg(nvl(mgr, 0))
  from emp;
-- Die Funktionen AVG und MEDIAN im Vergleich
select round(avg(mgr)) avg_null,
       avg(nvl(mgr, 0)) avg,
       median(mgr) median_null,
       median(nvl(mgr, 0)) median
  from emp;
  
-- Verwendung der distinct-Klausel in Gruppenfunktionen
select count(unique job) berufe
  from emp;
  
-- Verwendung der GROUP BY-Klausel
select deptno,
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal
  from emp
 group by deptno;
 
-- Gruppierung über einen null-Wert
select trunc(comm, -3) comm_group, count(*) amount
  from emp
 group by trunc(comm, -3);

-- Auswertung nach DEPTNO und JOB
select deptno, job, 
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal
  from emp
 group by deptno, job
 order by deptno, job;
 
-- Test: Ist die Reihenfolge der GROUP BY-Klausel relevant?
select deptno, job, 
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal
  from emp
 group by job, deptno
 order by deptno, job;
 
-- Erweiterung um Abteilung 40
select d.deptno, e.job, 
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal,
       count(e.deptno) anzahl
  from emp e
  right join dept d on e.deptno = d.deptno
 group by d.deptno, e.job
 order by d.deptno, e.job;

-- Filterung von Gruppenfunktionen mit HAVING
select deptno, min(sal), max(sal), sum(sal)
  from emp
 group by deptno
 order by deptno;
 
select deptno, min(sal), max(sal), sum(sal)
  from emp
 where deptno != 10
 group by deptno
having sum(sal) < 10000
 order by deptno;
 
-- Erweiterung der GROUP BY-Klausel durch ROLLUP
select deptno, job, 
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal,
       count(empno) anzahl
  from emp e
 group by rollup(deptno, job)
 order by deptno, job;
  
-- Erweiterung der GROUP BY-Klausel durch CUBE
select deptno, job, 
       min(sal) min_sal,
       max(sal) max_sal,
       sum(sal) sum_sal,
       count(empno) anzahl
  from emp e
 group by cube(deptno, job)
 order by deptno, job;

-- Verfeinerung der Ausgabe durch GROUPING
select case grouping(d.dname)
       when 1 then 'Alle Abteilungen'
       else d.dname end abteilung,
       case grouping(e.job)
       when 1 then 'Alle Berufe'
       else e.job end beruf,
       grouping(d.dname) dept_group,
       grouping(e.job) job_group,
       sum(e.sal) summe
  from dept d
  join emp e on d.deptno = e.deptno
 group by cube(d.dname, e.job);

-- Schachtelung von Gruppenfunktionen: Zuerst fehlerhaft
select deptno, min(avg(sal))
  from emp
 group by deptno;
 
-- ... dann korrigiert
select min(avg(sal))
  from emp
 group by deptno;

-- Verwendung der Funktion RANK und DENSE_RANK
select rank(1600) within group 
         (order by sal desc) rang,
       dense_rank(1600) within group 
         (order by sal desc) dense_rang
  from emp;

-- Darstellung der Mitarbeiter nach Gehalt
select ename, job, sal
  from emp
 order by sal desc;
 
select deptno,
       rank(1600) within group 
         (order by sal desc) rang,
       dense_rank(1600) within group 
         (order by sal desc) dense_rang
  from emp
 group by deptno;
  
-- Darstellung der Mitarbeiter nach Abteilung und Gehalt
select deptno, ename, job, sal
  from emp
 order by deptno, sal desc;
 
-- Verwendung der RANK-Funktion mit mehreren Parametern
select rank(1250, 900) within group 
         (order by sal desc, comm desc) rang
  from emp
 where job = 'SALESMAN';
 
select ename, sal, comm
  from emp
 where job = 'SALESMAN'
 order by sal desc, comm desc;
 
-- Verwendung der Funktionen FIRST und LAST
-- Als Benutzer SH ausführen!

set timing on

select min(prod_id) keep
         (dense_rank first order by sum(amount_sold) desc) top_revenue, 
       min(prod_id) keep
         (dense_rank last order by sum(amount_sold) desc) flop_revenue, 
       min(prod_id) keep 
         (dense_rank first order by sum(quantity_sold) desc) top_seller, 
       min(prod_id) keep 
         (dense_rank last order by sum(quantity_sold) desc) flop_seller
  from sales 
 group by prod_id, channel_id;
 
-- Versuch, die PROD_ID und die maximale Umsatzsumme gleichzeitig zu erfragen:
select min(prod_id) keep
         (dense_rank first order by 
            sum(amount_sold) desc) prod_id,
       max(sum(amount_sold)) max_amount
  from sales 
 group by prod_id, channel_id;
 
-- Verwendung der Funktion LISTAGG
select deptno, 
       listagg (ename, ':') within group
         (order by ename) mitarbeiterliste
  from emp
 group by deptno;
 